VERSION 2.00
Begin Form FTP_form 
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Quick FTP  Version 2.2"
   ClientHeight    =   4170
   ClientLeft      =   690
   ClientTop       =   1785
   ClientWidth     =   8010
   Height          =   4860
   Icon            =   QUICKFTP.FRX:0000
   Left            =   630
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   4170
   ScaleWidth      =   8010
   Top             =   1155
   Width           =   8130
   Begin ListBox messagelist 
      Height          =   810
      Left            =   0
      TabIndex        =   12
      Top             =   2880
      Width           =   8055
   End
   Begin Socket Socket1 
      Backlog         =   1
      Binary          =   -1  'True
      Blocking        =   -1  'True
      Broadcast       =   0   'False
      BufferSize      =   0
      HostAddress     =   ""
      HostFile        =   ""
      HostName        =   ""
      InLine          =   0   'False
      Interval        =   0
      KeepAlive       =   0   'False
      Left            =   4440
      Linger          =   0
      LocalPort       =   0
      LocalService    =   ""
      Peek            =   0   'False
      Protocol        =   0
      RecvLen         =   0
      RemotePort      =   0
      RemoteService   =   ""
      ReuseAddress    =   0   'False
      Route           =   -1  'True
      SendLen         =   0
      TabIndex        =   9
      Timeout         =   0
      Top             =   0
      Type            =   1
      Urgent          =   0   'False
   End
   Begin Socket Socket2 
      Backlog         =   1
      Binary          =   -1  'True
      Blocking        =   -1  'True
      Broadcast       =   0   'False
      BufferSize      =   0
      HostAddress     =   ""
      HostFile        =   ""
      HostName        =   ""
      InLine          =   0   'False
      Interval        =   0
      KeepAlive       =   0   'False
      Left            =   5040
      Linger          =   0
      LocalPort       =   0
      LocalService    =   ""
      Peek            =   0   'False
      Protocol        =   0
      RecvLen         =   0
      RemotePort      =   0
      RemoteService   =   ""
      ReuseAddress    =   0   'False
      Route           =   -1  'True
      SendLen         =   0
      TabIndex        =   8
      Timeout         =   0
      Top             =   0
      Type            =   1
      Urgent          =   0   'False
   End
   Begin Timer Timer2 
      Enabled         =   0   'False
      Interval        =   1000
      Left            =   3960
      Top             =   0
   End
   Begin TextBox Cycle_sec 
      Height          =   285
      Left            =   7320
      TabIndex        =   6
      Text            =   "0"
      Top             =   80
      Width           =   615
   End
   Begin ListBox Dir_list 
      Height          =   2175
      Left            =   0
      Sorted          =   -1  'True
      TabIndex        =   4
      Top             =   720
      Width           =   8055
   End
   Begin Label lblStatus 
      Caption         =   "Not connected"
      Height          =   255
      Left            =   1320
      TabIndex        =   11
      Top             =   3840
      Width           =   5295
   End
   Begin Label Label4 
      Caption         =   "Status:"
      Height          =   255
      Left            =   240
      TabIndex        =   10
      Top             =   3840
      Width           =   1095
   End
   Begin Label TimeLeft 
      Caption         =   "TimeLeft"
      Height          =   255
      Left            =   6960
      TabIndex        =   7
      Top             =   3840
      Visible         =   0   'False
      Width           =   855
   End
   Begin Label Label2 
      Caption         =   "cycle time (sec):"
      Height          =   255
      Left            =   5760
      TabIndex        =   5
      Top             =   120
      Width           =   1455
   End
   Begin Line Line1 
      X1              =   0
      X2              =   8040
      Y1              =   3720
      Y2              =   3720
   End
   Begin Label Message 
      Height          =   495
      Left            =   1320
      TabIndex        =   1
      Top             =   4200
      Visible         =   0   'False
      Width           =   4935
   End
   Begin Label Label3 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Messages :"
      Height          =   255
      Left            =   240
      TabIndex        =   3
      Top             =   4200
      Visible         =   0   'False
      Width           =   1095
   End
   Begin Label Host_name 
      BackColor       =   &H00C0C0C0&
      Caption         =   "< Not connected >"
      Height          =   495
      Left            =   840
      TabIndex        =   2
      Top             =   120
      Width           =   4815
   End
   Begin Label Label1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Host :"
      Height          =   255
      Left            =   240
      TabIndex        =   0
      Top             =   120
      Width           =   615
   End
   Begin Menu Menu_connection 
      Caption         =   "&Host"
      Begin Menu menu_Connection_item 
         Caption         =   "&Connect.."
         Index           =   0
      End
      Begin Menu menu_Connection_item 
         Caption         =   "&Disconnect.."
         Index           =   1
      End
      Begin Menu menu_Connection_item 
         Caption         =   "&Abort"
         Index           =   2
      End
      Begin Menu menu_Connection_item 
         Caption         =   "E&xit"
         Index           =   3
      End
      Begin Menu menu_Connection_item 
         Caption         =   "D&o It All!!"
         Index           =   4
         Visible         =   0   'False
      End
   End
   Begin Menu Menu_file 
      Caption         =   "&Transfer"
      Begin Menu Menu_file_item 
         Caption         =   "&Get.."
         Index           =   0
      End
      Begin Menu Menu_file_item 
         Caption         =   "&Put.."
         Index           =   1
      End
      Begin Menu mnuStopTimer 
         Caption         =   "&Stop Timer"
      End
   End
   Begin Menu Menu_directory 
      Caption         =   "&Directory"
      Begin Menu Menu_directory_item 
         Caption         =   "&Change"
         Index           =   0
      End
      Begin Menu Menu_directory_item 
         Caption         =   "&Parent"
         Index           =   1
      End
      Begin Menu Menu_directory_item 
         Caption         =   "&Dir list"
         Index           =   2
      End
   End
   Begin Menu Menu_settings 
      Caption         =   "&Settings"
      Begin Menu Menu_setting_items 
         Caption         =   "&Ascii type"
         Index           =   0
      End
      Begin Menu Menu_setting_items 
         Caption         =   "&Binary type"
         Index           =   1
      End
      Begin Menu Menu_setting_items 
         Caption         =   "&Mask"
         Index           =   2
         Visible         =   0   'False
      End
   End
   Begin Menu Quote_menu 
      Caption         =   "&Command"
      Begin Menu Quote_command 
         Caption         =   "&Send"
      End
   End
   Begin Menu AboutMenu 
      Caption         =   "&About"
   End
End


Sub AboutMenu_Click ()
  '
  Dim Msg, endofl
  endofl = Chr$(13) & Chr$(10)
  '
  Msg = "Quick FTP scheduled file transfer utility" & endofl
  Msg = Msg & "was developed using Visual Basic 3.0 and" & endofl
  Msg = Msg & "SocketWrench/VB (TM) Custom Control 1.0" & endofl
  Msg = Msg & "from Catalyst Software (www.earthlink.net)" & endofl
  Msg = Msg & endofl
  Msg = Msg & "Command line may have 0, 7, 8, or 9 arguments in exactly this order:" & endofl
  Msg = Msg & endofl
  Msg = Msg & "QUICKFTP HostName LoginName Password Directory [GET|PUT] SourceFileName DestFileName [ASCII|BINARY] [NOTIFY|SILENT]" & endofl
  Msg = Msg & endofl
  Msg = Msg & "(These last two are optional defaulting to ASCII NOTIFY. Use '?' instead of a parameter to prompt on startup" & endofl
  Msg = Msg & endofl
  Msg = Msg & "For example: QUICKFTP ftp.stolaf.edu anonymous ? pub/origami/WIN GET qckftp21.zip c:/temp/q.zip B N" & endofl
  Msg = Msg & endofl
  Msg = Msg & "Comments: Bob Hanson (hansonr@stolaf.edu)" & endofl
  
  '
  MsgBox Msg, 64, "About QuickFTP"
  '
End Sub

Sub Cycle_sec_GotFocus ()
'__
'__ FTP_form Cycle_sec_GotFocus
'__   calls     GLOBAL switch_to
'__
 initialcycle = Val(cycle_sec)
 switch_to cycle_sec
End Sub

Sub Cycle_sec_LostFocus ()
'__
'__ FTP_form Cycle_sec_LostFocus
'__   calls     FTP_form ResetTimer
'__
  If initialcycle = Val(cycle_sec) Then Exit Sub
  Call ResetTimer(Val(cycle_sec))
End Sub

Sub Dir_list_Click ()
 clickindex = Dir_list.ListIndex
End Sub

Sub Dir_list_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)
'__
'__ FTP_form Dir_list_MouseUp
'__
'__   parameter Button As Integer
'__   parameter Shift As Integer
'__   parameter X As Single
'__   parameter Y As Single
'__
 On Error Resume Next
 If clickindex = -1 Then Exit Sub
 Dir_list.Selected(clickindex) = (olddirclick <> clickindex)
 Menu_directory_item(0).Caption = "&Change Directory"
 olddirclick = clickindex
 If clickindex = -1 Then Exit Sub
 If Dir_list.Selected(clickindex) Then
   Menu_directory_item(0).Caption = "&Change to " & Dir_list.List(Dir_list.ListIndex)
 End If
End Sub

Sub Disable_menus ()
'__
'__ FTP_form Disable_menus
'__   called by FTP_form Do_display_options
'__
  '
'  Menu_connection.Enabled = False
  Menu_file.Enabled = False
  Menu_directory.Enabled = False
  Menu_settings.Enabled = False
  Quote_menu.Enabled = False
  '
End Sub

Sub Do_display_options ()
'__
'__ FTP_form Do_display_options
'__   called by FTP_form DoConnFTPDisc
'__   called by FTP_form DoDisconnect
'__   called by FTP_form getfilenow
'__   called by FTP_form GoToDir
'__   called by FTP_form menu_connection_item_click
'__   called by FTP_form Menu_directory_item_Click
'__   called by FTP_form Menu_setting_items_Click
'__   called by FTP_form putfilenow
'__   called by FTP_form SendFTPCOMMAND
'__   calls     FTP_form Disable_menus
'__
  '
  Disable_menus
  FTP_form!Message.Caption = ""
  FTP_form.MousePointer = 11
  
  '
End Sub

Sub Do_the_dirlist ()
'__
'__ FTP_form Do_the_dirlist
'__   called by FTP_form Menu_directory_item_Click
'__   called by FTP_form Menu_setting_items_Click
'__   calls     GLOBAL FTPGetDirList
'__   calls     GLOBAL Show_the_dir_list
'__
  'list directory info in a file identified with Dir_file
  'read the contents of that file and put results in
  'listbox Dir_list
  '
  Dim d_File
  Filt$ = MaskType
  d_File = Dir_file
  If Connected Then
    Dir_list.Clear
    clickindex = -1
    success = FTPGetDirList(Socket1, socket2, Message)
    If success Then
      Show_the_dir_list
    Else
      M$ = ctldata
      Message.Caption = M$
    End If
  End If
  '
End Sub

Function DoConnectOnly ()
'__
'__ FTP_form DoConnectOnly
'__   called by FTP_form DoConnFTPDisc
'__   called by FTP_form menu_connection_item_click
'__   calls     GLOBAL FTPConnect
'__   calls     GLOBAL FTPLogin
'__   calls     FTP_form Undo_Display_Options
'__
    Connected = False
    DoConnectOnly = False
    menu_connection.Enabled = False'disallow connect
    
    FTP_form!Message.Caption = "Logging in " & userid & " to " & hostname
    If Not FTPConnect(hostname, Socket1, Message) Then
            MsgBox "Unable to connect to remote host"
      Ms$ = ctldata
      FTP_form!Message.Caption = Ms$
      FTP_form.Host_name.Caption = "< Not connected >"
            Exit Function
    End If
    If Not FTPLogin(Trim$(userid), Trim$(password), Socket1, socket2, Message) Then
            Undo_Display_Options
            DoConnectOnly = False
            FTP_form.MousePointer = 0
            FTP_form.Socket1.Action = SOCKET_CLOSE
            timer2.Enabled = False
            Ms$ = ctldata
            FTP_form!Message.Caption = Ms$
            FTP_form.Host_name.Caption = "< Not connected >"
            Exit Function
    End If
    Undo_Display_Options
    Connected = True
    DoConnectOnly = True
    FTP_form.Host_name.Caption = hostname
End Function

Sub DoConnFTPDisc ()
'__
'__ FTP_form DoConnFTPDisc
'__   called by FTP_form Form_Load
'__   called by FTP_form menu_connection_item_click
'__   called by FTP_form Timer2_Timer
'__   calls     GLOBAL FTPGetDirectory
'__   calls     GLOBAL FTPSetDirectory
'__   calls     GLOBAL getword
'__   calls     FTP_form Do_display_options
'__   calls     FTP_form DoConnectOnly
'__   calls     FTP_form DoDisconnect
'__   calls     FTP_form getfilenow
'__   calls     FTP_form putfilenow
'__   calls     FTP_form ResetTimer
'__   calls     FTP_form Undo_Display_Options
'__
    t0 = Timer
    timer2.Enabled = False
    timeleft.Visible = False
    Do_display_options
    If DoConnectOnly() Then
      If serverdirect <> "" Then
        C_dir$ = serverdirect
        Call FTPSetDirectory(C_dir$, Socket1, Message)
      Else
        Call FTPGetDirectory(Socket1, Message)
      End If
      While list_data <> ""
       If list_data = "ENDLIST" Then
         list_data = ""
       Else
         src_name = getword(list_data, "Source file name", "")
         dest_name = getword(list_data, "Destination file name", "")
       End If
       If src_name <> "" And dest_name <> "" Then
        If putmode Then
          Call putfilenow
        Else
          Call getfilenow
        End If
       End If
      Wend
      
      DoDisconnect
    Else
      Ms$ = ctldata
      FTP_form!Message.Caption = Ms$
      FTP_form.Host_name.Caption = "< Not connected >"
    End If
    Undo_Display_Options
    Call ResetTimer(Val(cycle_sec) - (Timer - t0))
    If timer2.Enabled Then FTP_form!Message.Caption = "counting..."
End Sub

Sub DoDisconnect ()
'__
'__ FTP_form DoDisconnect
'__   called by FTP_form DoConnFTPDisc
'__   called by FTP_form menu_connection_item_click
'__   calls     GLOBAL FTPDisconnect
'__   calls     FTP_form Do_display_options
'__   calls     FTP_form Undo_Display_Options
'__
    timer2.Enabled = False
    timeleft.Visible = False
    If Connected Then
      Do_display_options
      Call FTPDisconnect(Socket1)
      Undo_Display_Options
      Connected = False
      FTP_form.Host_name.Caption = "< Not connected >"
      FTP_form.Message.Caption = hostname & " disconnected"
      Dir_list.Clear
      olddirclick = -1
    End If

End Sub

Sub Enable_menus ()
'__
'__ FTP_form Enable_menus
'__   called by FTP_form Menu_directory_item_Click
'__   called by FTP_form Menu_setting_items_Click
'__   called by FTP_form Undo_Display_Options
'__
  '
  menu_connection.Enabled = True
  Menu_file.Enabled = True
  Menu_directory.Enabled = True
  Menu_settings.Enabled = True
  Quote_menu.Enabled = True
  '
End Sub

Function Exit_program () As Integer
'__
'__ FTP_form Exit_program
'__   called by FTP_form Form_QueryUnload
'__
  'give a message box to enable the operator to terminate
  'the program or not
  '
  Dim DgDef, Msg, Response, Title
  '
  Title = "Exit QuickFTP"
  Msg = hostname & " is still connected. Do you want to close the connection and exit?"
  DgDef = MB_YESNO + MB_ICONQUESTION
  Response = MsgBox(Msg, DgDef, Title)
  '
  Exit_program = Response
  '
End Function

Sub Form_Load ()
'__
'__ FTP_form Form_Load
'__   calls     GLOBAL GetTempFileName
'__   calls     GLOBAL getword
'__   calls     FTP_form DoConnFTPDisc
'__   calls     FTP_form menu_connection_item_click
'__
  On Error Resume Next
  Kill logfile
  '
  click_index = -1
  Connected = False
  DirType = False
  transtype = Asc("A")
  MaskType = "" ' if "*.*" then you don't get directories
  '
  hostname = connectform!NodeEdit.Text
  userid = connectform!UserEdit.Text
  password = ""
  serverdirect = connectform!txtDirect

  namebuff$ = String$(100, 0)
  wI = GetTempFileName(0, "QFTP", 0, namebuff$)
  Dir_file = Left$(namebuff$, InStr(namebuff$, Chr(0)) - 1)
  wI = GetTempFileName(0, "QFTP", 0, namebuff$)
  Temp_File = Left$(namebuff$, InStr(namebuff$, Chr(0)) - 1)
  
  '
  FTP_form.Socket1.HostFile = ""
  
  FTP_form.Show
  cline = Command$
  'MsgBox CurDir

  CRLF = Chr$(13) & Chr$(10)
  list_data = "ENDLIST"
  If cline <> "" Then 'have automatic process
   hostname = getword(cline, "Host Name", "")
   mess = mess & "Host Name: " & hostname & CRLF
   userid = getword(cline, "Login Name", "")
   mess = mess & "Login Name: " & userid & CRLF
   password = getword(cline, "Password", "HIDDENVALUE")
   serverdirect = getword(cline, "Initial Directory", ".")
   mess = mess & "Initial Directory: " & serverdirect & CRLF & CRLF

   putmode = (UCase(Left(getword(cline, "PUT or GET", "GET") & " ", 1)) = "P")
   If putmode Then
     mess = mess & "PUT "
   Else
     mess = mess & "GET "
   End If
   src_name = getword(cline, "Source File Name", "")
   If Left(src_name, 1) = "<" Then
     listfile = Mid(src_name, 2)
     Open listfile For Binary As #1
     list_data = Space(LOF(1))
     Get 1, 1, list_data
     Close 1
     mess = mess & "From " & src_name & ":" & CRLF & list_data & CRLF
     For i = 1 To Len(list_data)
      If Mid(list_data, i, 1) = Chr(10) Or Mid(list_data, i, 1) = Chr(13) Then
        Mid(list_data, i, 1) = " "
      End If
     Next
   Else
     mess = mess & src_name & CRLF
     dest_name = getword(cline, "Destination File Name", "")
     mess = mess & "--> " & dest_name & CRLF
   End If
   If putmode Then
    Local_File_Name = src_name
    Host_File_Name = dest_name
   Else
    Host_File_Name = src_name
    Local_File_Name = dest_name
   End If
   transtype = Asc(UCase(getword(cline, "ASCII or BINARY", "ASCII")) & " ")
   If transtype = 32 Then transtype = Asc("A")
   If transtype <> Asc("A") Then transtype = Asc("I")
   If transtype = Asc("A") Then
     mess = mess & "mode ASCII"
   Else
     mess = mess & "mode BINARY"
   End If
   silent = UCase(Left(getword(cline, "NOTIFY or SILENT", "NOTIFY") & " ", 1))
   notify = (silent <> "S")
   doitmode = True
   commandmode = True
   ok = ID_OK
   If notify Then ok = MsgBox(mess, MB_OKCANCEL Or MB_QUESTION)
   If ok = ID_OK Then
     DoConnFTPDisc
     If notify Then MsgBox (src_name & " Operation complete")
   End If
   Unload FTP_form
  End If

  menu_connection_item_click (0)
End Sub

Sub Form_QueryUnload (Cancel As Integer, UnloadMode As Integer)
'__
'__ FTP_form Form_QueryUnload
'__
'__   parameter Cancel As Integer
'__   parameter UnloadMode As Integer
'__   calls     FTP_form Exit_program
'__
  '
  'when finishing via - control program checks for connected
  'and gives a message to the operator, he then can decide
  'to finish or not
  'Also a warning will be given when the release was not
  'successful
  '
  If Connected Then
    If Exit_program() = ID_YES Then
      Cancel = False
    Else
      Cancel = True
    End If
  Else
    Cancel = False
  End If
  '
End Sub

Sub Form_Unload (Cancel As Integer)
'__
'__ FTP_form Form_Unload
'__
'__   parameter Cancel As Integer
'__
      On Error Resume Next
      Kill Dir_file
      Kill Temp_File
      If Socket1.Connected Then Socket1.Action = SOCKET_CLOSE
      If socket2.Listening Or socket2.Connected Then socket2.Action = SOCKET_CLOSE
      ti = Timer: While Timer - 1 < ti: DoEvents: Wend
      End                        'exit program
End Sub

Sub getfilenow ()
'__
'__ FTP_form getfilenow
'__   called by FTP_form DoConnFTPDisc
'__   called by FTP_form menu_connection_item_click
'__   called by FTP_form Menu_file_item_Click
'__   called by FTP_form Timer1_Timer
'__   called by FTP_form Timer2_Timer
'__   calls     GLOBAL FTPGetFile
'__   calls     FTP_form Do_display_options
'__   calls     FTP_form ResetTimer
'__   calls     FTP_form Undo_Display_Options
'__
Static going
    If going Then Exit Sub
    going = True
    t0 = Timer
    timer2.Enabled = False
    transferaborted = False
    Do_display_options
    FTP_form!Message.Caption = ""
    FTP_form!lblStatus.Caption = "Getting " & src_name
    success = FTPGetFile(src_name, Temp_File, Socket1, socket2, Message)
    If transferaborted Or Not success Then
      Ms$ = ctldata
      FTP_form!Message.Caption = Ms$
      If notify Or commandmode Then MsgBox Ms$
      lblStatus.Caption = "Ready"
      If transferaborted Then Message.Caption = "File transfer aborted"
    Else
      FTP_form!lblStatus.Caption = "Copying temporary file..."
      On Error Resume Next
      Kill dest_name
      On Error GoTo getfileerror
      FileCopy Temp_File, dest_name
      Kill Temp_File
      If Val(cycle_sec) = 0 Then also = "" Else also = " and counting"
      FTP_form!lblStatus.Caption = "Transfer OK; received " & FileLen(dest_name) & " bytes" & also
    End If
    If Not transferaborted Then Call ResetTimer(Val(cycle_sec) - (Timer - t0))
    Undo_Display_Options
    going = False
    Exit Sub

getfileerror:
    Undo_Display_Options
    If transferaborted Then
      FTP_form!lblStatus.Caption = "Transfer aborted"
      going = False
      Exit Sub
    End If
    If Err = 53 Then Resume Next 'File not found
    mess = Error(Err) & "--"
    If Err = 75 Then   'Access error
      mess = mess & "Retrying..."
      FTP_form!Message.Caption = mess
      DoEvents
      Resume
    End If
    FTP_form!Message.Caption = mess
    Exit Sub
End Sub

Sub GoToDir (C_dir$)
'__
'__ FTP_form GoToDir
'__
'__   parameter C_dir$
'__   called by FTP_form menu_connection_item_click
'__   called by FTP_form Menu_directory_item_Click
'__   calls     GLOBAL FTPSetDirectory
'__   calls     FTP_form Do_display_options
'__   calls     FTP_form Menu_directory_item_Click
'__   calls     FTP_form Undo_Display_Options
'__
    Do_display_options
      FTP_form!lblStatus.Caption = "Changing directory to " & C_dir$
      Call FTPSetDirectory(C_dir$, Socket1, Message)
      Undo_Display_Options
      Ms$ = ctldata
      FTP_form!Message.Caption = Ms$
      Call Menu_directory_item_Click(2)
End Sub

Sub lblStatus_Change ()
' logmessage lblStatus
End Sub

Sub logmessage (Message)
'__
'__ FTP_form logmessage
'__
'__   parameter Message
'__   called by FTP_form Message_Change
'__
 If Val(Message) > 0 Then Exit Sub
 messagelist.AddItem Message
 messagelist.TopIndex = messagelist.ListCount - 1
 messagelist.Refresh
On Error Resume Next
unit = FreeFile
Open LogFileName For Append As #unit
Print #unit, Time$ & " " & Message
Close unit
End Sub

Sub Menu_connection_Click ()
  'set menu active depending on connection
  'connect
  menu_connection_item(0).Enabled = (Connected = False)
  'disconnect
  menu_connection_item(1).Enabled = (Connected = True)
  'abort
  menu_connection_item(2).Enabled = (Connected = True) Or (timer2.Enabled)
  '
End Sub

Sub menu_connection_item_click (Index As Integer)
'__
'__ FTP_form menu_connection_item_click
'__
'__   parameter Index As Integer
'__   called by FTP_form Form_Load
'__   calls     FTP_form Do_display_options
'__   calls     FTP_form DoConnectOnly
'__   calls     FTP_form DoConnFTPDisc
'__   calls     FTP_form DoDisconnect
'__   calls     FTP_form getfilenow
'__   calls     FTP_form GoToDir
'__   calls     FTP_form Menu_directory_item_Click
'__   calls     FTP_form putfilenow
'__   calls     FTP_form Undo_Display_Options
'__
  
  
  'do action depending on item
  '
  Select Case Index
  Case 0                    'Connect
    timer2.Enabled = False
    timeleft.Visible = False
    doitmode = False
    src_name = ""
    dest_name = ""
    connectform.Show 1
    If Not OKDialog Then Exit Sub
    messagelist.Clear
    Do_display_options
    If doitmode Then
      DoConnFTPDisc
    Else
      If DoConnectOnly() Then
       If serverdirect <> "" Then
         C_dir$ = serverdirect
         Call GoToDir(C_dir$)
       Else
         Call Menu_directory_item_Click(2)
       End If
       If cyclemode And src_name <> "" And dest_name <> "" Then
         If putmode Then
          Call putfilenow
         Else
          Call getfilenow
         End If
       End If
      End If
    End If
    Undo_Display_Options
  Case 1                    'Disconnect
    DoDisconnect
  Case 2                    'Abort
    timeleft.Visible = False
    If timer2.Enabled Then
      FTP_form!lblStatus.Caption = "Timer stopped"
      FTP_form!Message.Caption = ""
    End If
    timer2.Enabled = False
    transferaborted = True
  Case 3                    'Exit
    Unload FTP_form
  Case 4                          'do full cycle-connect,ftp,disconnect
    Call DoConnFTPDisc
  End Select
  '
End Sub

Sub Menu_directory_Click ()
  'set menu active depending on connection
  'change
  Menu_directory_item(0).Enabled = (Connected = True)
  'parent
  Menu_directory_item(1).Enabled = (Connected = True)
  'dir list
  Menu_directory_item(2).Enabled = (Connected = True)
  '
End Sub

Sub Menu_directory_item_Click (Index As Integer)
'__
'__ FTP_form Menu_directory_item_Click
'__
'__   parameter Index As Integer
'__   called by FTP_form GoToDir
'__   called by FTP_form menu_connection_item_click
'__   calls     GLOBAL getinput
'__   calls     FTP_form Do_display_options
'__   calls     FTP_form Do_the_dirlist
'__   calls     FTP_form Enable_menus
'__   calls     FTP_form GoToDir
'__   calls     FTP_form SendFTPCOMMAND
'__
  '
  
  Dim C_dir$
  '
  Select Case Index
  Case 0          'change
    If Dir_list.ListIndex > 0 Then
       C_dir$ = Dir_list.List(Dir_list.ListIndex)
    Else
       C_dir$ = Getinput("Directory Name", serverdirect)
    End If
    Call GoToDir(C_dir$)
  Case 1          'parent
    C_dir$ = ".."
    Call GoToDir(C_dir$)
  Case 2
    DirType = False
    Do_display_options
    FTP_form!lblStatus.Caption = "Getting directory info"
    Do_the_dirlist
    Call SendFTPCOMMAND("pwd", result$)
    iq = InStr(result$, Chr(34))
    If iq > 0 Then
      result$ = Mid$(result$, iq + 1)
      iq = InStr(result$, Chr(34))
      If iq > 0 Then
        result$ = Left$(result$, iq - 1)
        Menu_directory_item(2).Caption = "&List of " & result$
        serverdirect = result$
        Host_name = hostname & "   " & result$
      End If
    End If
    FTP_form.MousePointer = 0
    Enable_menus
    lblStatus = "Ready"
  End Select
  '
End Sub

Sub Menu_file_Click ()
  'set menu active depending on connection
  'get
  Menu_File_item(0).Enabled = (Connected = True)
  Menu_File_item(0).Checked = Not putmode
  'put
  Menu_File_item(1).Enabled = (Connected = True)
  Menu_File_item(1).Checked = putmode
  '
  MnuStopTimer.Enabled = timer2.Enabled
End Sub

Sub Menu_file_item_Click (Index As Integer)
'__
'__ FTP_form Menu_file_item_Click
'__
'__   parameter Index As Integer
'__   calls     FTP_form getfilenow
'__   calls     FTP_form putfilenow
'__
  '
  Select Case Index
  Case 0      'get
    putmode = False
    Get_file.Show 1
    If Not OKDialog Then Exit Sub
    '
    Call getfilenow
   Case 1      'put
    putmode = True
    Get_file.Show 1
    If Not OKDialog Then Exit Sub
    Call putfilenow
  End Select
  '
End Sub

Sub Menu_setting_items_Click (Index As Integer)
'__
'__ FTP_form Menu_setting_items_Click
'__
'__   parameter Index As Integer
'__   calls     GLOBAL Get_mask_type
'__   calls     FTP_form Do_display_options
'__   calls     FTP_form Do_the_dirlist
'__   calls     FTP_form Enable_menus
'__
  '
  Select Case Index
  Case 0                     'Ascii
    transtype = Asc("A")
  Case 1                     'binary
    transtype = Asc("I")
  Case 2                     'mask
    MaskType = Get_mask_type()
    Do_display_options
    Do_the_dirlist
    FTP_form.MousePointer = 0
    Enable_menus
  End Select
  '
End Sub

Sub Menu_settings_Click ()
  '
  Menu_setting_items(0).Checked = (transtype = Asc("A"))
  Menu_setting_items(1).Checked = (transtype = Asc("I"))
  '
  Menu_setting_items(0).Enabled = (Connected = True)
  Menu_setting_items(1).Enabled = (Connected = True)
  Menu_setting_items(2).Enabled = (Connected = True)
  '
End Sub

Sub Message_Change ()
'__
'__ FTP_form Message_Change
'__   calls     FTP_form logmessage
'__
 logmessage Message
End Sub

Sub mnuStopTimer_Click ()
    timeleft.Visible = False
    FTP_form!lblStatus.Caption = "Timer stopped"
    timer2.Enabled = False
End Sub

Sub putfilenow ()
'__
'__ FTP_form putfilenow
'__   called by FTP_form DoConnFTPDisc
'__   called by FTP_form menu_connection_item_click
'__   called by FTP_form Menu_file_item_Click
'__   called by FTP_form Timer2_Timer
'__   calls     GLOBAL FTPPutFile
'__   calls     FTP_form Do_display_options
'__   calls     FTP_form ResetTimer
'__   calls     FTP_form Undo_Display_Options
'__
Static going
    If going Then Exit Sub
    going = True
    t0 = Timer
    timer2.Enabled = False
    transferaborted = False
    Do_display_options
    FTP_form!Message.Caption = ""
    FTP_form!lblStatus.Caption = "Putting " & src_name & " (" & FileLen(src_name) & " bytes)"
    success = FTPPutFile(src_name, dest_name, Socket1, socket2, Message)
    If transferaborted Then
        Message.Caption = "File transfer aborted. Host data is probably corrupt."
        If notify Or commandmode Then MsgBox Message.Caption
    ElseIf Not success Then
        Ms$ = "Error in transmission: " & ctldata
        FTP_form!Message.Caption = Ms$
        If notify Or commandmode Then MsgBox Ms$
    Else
        FTP_form!lblStatus.Caption = "Transfer OK"
    End If
    If Not transferaborted Then Call ResetTimer(Val(cycle_sec) - (Timer - t0))
    Undo_Display_Options
    going = False
    Exit Sub

putfileerror:
    Undo_Display_Options
    If Err = 53 Then Resume Next 'File not found
    mess = Error(Err) & "--"
    If Err = 75 Then   'Access error
      mess = mess & "Retrying..."
      FTP_form!Message.Caption = mess
      DoEvents
      Resume
    End If
    FTP_form!Message.Caption = mess
    Exit Sub

End Sub

Sub Quote_command_Click ()
'__
'__ FTP_form Quote_command_Click
'__   calls     FTP_form SendFTPCOMMAND
'__
  'execute a command not implemented as standard command
  'in FTP4W.BAS
  '
  Dim answ$, DefVal, Msg, Title
  '
  DefVal = ""
  Msg = "Enter FTP command : "
  Title = "Quote option for FTP"
  '
  answ$ = InputBox$(Msg, Title, DefVal)
  If Len(Trim$(answ$)) = 0 Then
    Exit Sub
  Else
    Call SendFTPCOMMAND(answ$, result$)
  End If
  '
End Sub

Sub Quote_menu_Click ()
  '
  Quote_command.Enabled = (Connected = True)
  '
End Sub

Sub ResetTimer (tim)
'__
'__ FTP_form ResetTimer
'__
'__   parameter tim
'__   called by FTP_form Cycle_sec_LostFocus
'__   called by FTP_form DoConnFTPDisc
'__   called by FTP_form getfilenow
'__   called by FTP_form putfilenow
'__
    ttime = tim
    If ttime < 10 Then ttime = 10
    If Val(cycle_sec) > 0 Then
      timer2.Enabled = True
      timeleft = Int(ttime)
      timeleft.Visible = True
    Else
      timer2.Enabled = False
      timeleft.Visible = False
      cycle_sec = 0
    End If
End Sub

Sub SendFTPCOMMAND (commnd$, result As String)
'__
'__ FTP_form SendFTPCOMMAND
'__
'__   parameter commnd$
'__   parameter result As String
'__   called by FTP_form Menu_directory_item_Click
'__   called by FTP_form Quote_command_Click
'__   calls     GLOBAL FTPcommand
'__   calls     GLOBAL FTPResult
'__   calls     FTP_form Do_display_options
'__   calls     FTP_form Undo_Display_Options
'__
  '
    Do_display_options
    success = FTPcommand(commnd$, Socket1, Message)
    If Not success Then
        If notify Or commandmode Then MsgBox ctldata
    End If
    r = FTPResult(Socket1, Message)'don't take this out!
    Undo_Display_Options
    M$ = ctldata
    FTP_form!Message.Caption = M$
    result = ctldata

End Sub

Sub Socket1_Close ()
'__
'__ FTP_form Socket1_Close
'__   calls     FTP_form Undo_Display_Options
'__
    Socket1.Action = SOCKET_CLOSE
    FTP_form.Host_name.Caption = "< Not connected >"
    FTP_form.lblStatus.Caption = "Not connected"
    FTP_form.Message.Caption = hostname & " disconnected"
    Connected = False
    Undo_Display_Options

End Sub

Sub Socket2_Close ()
'__
'__ FTP_form Socket2_Close
'__   calls     FTP_form Undo_Display_Options
'__
    FTP_form.Host_name.Caption = "< Not connected >"
    FTP_form!lblStatus.Caption = "Not connected"
    FTP_form.Message.Caption = hostname & " disconnected"
    Connected = False
    Undo_Display_Options

End Sub

Sub Timer1_Timer ()
'__
'__ FTP_form Timer1_Timer
'__   calls     FTP_form getfilenow
'__
   timer2.Enabled = False
   timeleft.Visible = False
   Call getfilenow
End Sub

Sub Timer2_Timer ()
'__
'__ FTP_form Timer2_Timer
'__   calls     FTP_form DoConnFTPDisc
'__   calls     FTP_form getfilenow
'__   calls     FTP_form putfilenow
'__
 If Not timer2.Enabled Then Exit Sub
 timeleft = timeleft - 1
 If timeleft > 0 Then Exit Sub
   timeleft = 0
   timer2.Enabled = False
   timeleft.Visible = False
   If doitmode Then
     Call DoConnFTPDisc
   ElseIf putmode Then
     Call putfilenow
   Else
     Call getfilenow
   End If
End Sub

Sub Undo_Display_Options ()
'__
'__ FTP_form Undo_Display_Options
'__   called by FTP_form DoConnectOnly
'__   called by FTP_form DoConnFTPDisc
'__   called by FTP_form DoDisconnect
'__   called by FTP_form getfilenow
'__   called by FTP_form GoToDir
'__   called by FTP_form menu_connection_item_click
'__   called by FTP_form putfilenow
'__   called by FTP_form SendFTPCOMMAND
'__   called by FTP_form Socket1_Close
'__   called by FTP_form Socket2_Close
'__   calls     FTP_form Enable_menus
'__
  '
  FTP_form.MousePointer = 0
  Enable_menus
  '
End Sub

